/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.uddi.inquiry_v2.uddi_org;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWUDDIRegistryList;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.ws.api.WSTemplateBase;
import filenet.ws.listener.uddi.api_v2.uddi_org.BindingDetail;
import filenet.ws.listener.uddi.api_v2.uddi_org.BindingKey;
import filenet.ws.listener.uddi.api_v2.uddi_org.BindingTemplate;
import filenet.ws.listener.uddi.api_v2.uddi_org.BusinessDetail;
import filenet.ws.listener.uddi.api_v2.uddi_org.BusinessInfo;
import filenet.ws.listener.uddi.api_v2.uddi_org.BusinessInfos;
import filenet.ws.listener.uddi.api_v2.uddi_org.BusinessKey;
import filenet.ws.listener.uddi.api_v2.uddi_org.BusinessList;
import filenet.ws.listener.uddi.api_v2.uddi_org.BusinessService;
import filenet.ws.listener.uddi.api_v2.uddi_org.BusinessServices;
import filenet.ws.listener.uddi.api_v2.uddi_org.Description;
import filenet.ws.listener.uddi.api_v2.uddi_org.DispositionReport;
import filenet.ws.listener.uddi.api_v2.uddi_org.Name;
import filenet.ws.listener.uddi.api_v2.uddi_org.ServiceDetail;
import filenet.ws.listener.uddi.api_v2.uddi_org.ServiceInfo;
import filenet.ws.listener.uddi.api_v2.uddi_org.ServiceInfos;
import filenet.ws.listener.uddi.api_v2.uddi_org.ServiceKey;
import filenet.ws.listener.uddi.api_v2.uddi_org.ServiceList;
import filenet.ws.listener.uddi.api_v2.uddi_org.TModel;
import filenet.ws.listener.uddi.api_v2.uddi_org.TModelDetail;
import filenet.ws.listener.uddi.api_v2.uddi_org.TModelInfo;
import filenet.ws.listener.uddi.api_v2.uddi_org.TModelInfos;
import filenet.ws.listener.uddi.api_v2.uddi_org.TModelKey;
import filenet.ws.listener.uddi.api_v2.uddi_org.TModelList;
import filenet.ws.listener.uddi.api_v2.uddi_org.Truncated;
import filenet.ws.listener.uddi.inquiry_v2.uddi_org.WSWorkflowServiceInfo;
import filenet.ws.listener.utils.WSListenerProperties;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSUddiManager {
    protected static final Logger logger = Logger.getLogger("filenet.ws.listener.uddi");
    protected static final String m_className = "WSUddiManager";
    private static Hashtable m_uddiManagers = new Hashtable();
    private VWSession m_vwSession = null;
    private String m_baseURL = null;
    private String m_cpName = null;
    private filenet.ws.listener.uddi.api_v2.uddi_org.BusinessEntity m_businessEntity = null;
    private Hashtable m_services = new Hashtable();
    private BusinessService[] m_serviceArray = null;
    private Hashtable m_tModels = new Hashtable();
    private TModel[] m_tModelArray = null;
    private Hashtable m_bindings = new Hashtable();
    private BindingTemplate[] m_bindingArray = null;
    private VWWorkflowSignature[] m_workflows = null;
    private int m_isolatedRegion = -1;
    private String m_operator = "FileNet";
    private String m_authorizedName = "PE";

    public static String _get_FILE_DATE() {
        return "$Date:   29 Jun 2007 01:47:10  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.9  $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WSUddiManager(VWSession session, String baseURL) throws VWException {
        String m_method = "Ctor";
        try {
            logger.entering(m_className, m_method);
            this.setVWSession(session);
            this.setBaseURL(baseURL);
            this.init();
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    private synchronized void init() throws VWException {
        String m_method = "init";
    }

    protected void cleanup() {
        this.m_vwSession = null;
    }

    private void setVWSession(VWSession vwSession) throws VWException {
        this.m_vwSession = vwSession;
        if (this.m_vwSession != null) {
            this.m_isolatedRegion = this.m_vwSession.getIsolatedRegion();
            this.m_cpName = this.m_vwSession.getConnectionPointName();
        }
    }

    private void setBaseURL(String baseURL) {
        this.m_baseURL = baseURL;
    }

    protected static WSUddiManager getWSUddiManager(VWSession session, String baseURL) throws VWException {
        String m_method = "getWSUddiManager(session, baseURL)";
        logger.entering(m_className, m_method);
        try {
            Object obj;
            if (session == null || baseURL == null) {
                WSUddiManager wSUddiManager = null;
                return wSUddiManager;
            }
            String routerURL = session.getRouterURL();
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "routerURL = " + routerURL);
                logger.finest(m_className, m_method, "baseURL = " + baseURL);
            }
            WSUddiManager uddiManager = null;
            if (routerURL != null && (obj = m_uddiManagers.get(routerURL)) != null && obj instanceof WSUddiManager) {
                uddiManager = (WSUddiManager)obj;
                uddiManager.setVWSession(session);
                uddiManager.setBaseURL(baseURL);
            }
            if (uddiManager == null) {
                uddiManager = new WSUddiManager(session, baseURL);
                m_uddiManagers.put(routerURL, uddiManager);
            }
            WSUddiManager wSUddiManager = uddiManager;
            return wSUddiManager;
        }
        catch (VWException ex) {
            logger.throwing(m_className, m_method, ex);
            throw ex;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    static WSUddiManager getWSUddiManager() throws VWException {
        String m_method = "getWSUddiManager";
        WSListenerProperties m_props = null;
        logger.entering(m_className, m_method);
        try {
            MessageContext msgContext = MessageContext.getCurrentContext();
            HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            if (req == null) {
                throw new VWException("filenet.ws.listener.axis.ValidatorHandler.invalidState", "Invalid Invocation:  Should be a post.");
            }
            m_props = (WSListenerProperties)req.getAttribute("P8BPM.wsListenerProperties");
            if (m_props == null) {
                throw new VWException("filenet.ws.listener.axis.ValidatorHandler.noProperties", "Invalid Invocation:  Listener properties are not set.");
            }
            String cpName = (String)req.getAttribute("P8BPM.wsCurrentCPName");
            VWSession session = m_props.getVWSession(cpName);
            String baseURL = m_props.getProperty("listener.base.url");
            WSUddiManager wSUddiManager = WSUddiManager.getWSUddiManager(session, baseURL);
            return wSUddiManager;
        }
        catch (VWException ex) {
            logger.throwing(m_className, m_method, ex);
            throw ex;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    public static String uddiDiscovery(VWSession session, String baseURL, String queryString) throws Exception {
        String m_method = "uddiDiscovery";
        logger.entering(m_className, m_method);
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "queryString = " + queryString);
        }
        if (session == null || baseURL == null || queryString == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(queryString, "=");
        String key = null;
        while (st.hasMoreTokens()) {
            key = st.nextToken();
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "key = " + key);
            }
            if (key == null || key.trim().compareTo("businessKey") != 0 || !st.hasMoreTokens()) continue;
            key = st.nextToken();
        }
        try {
            WSUddiManager uddiManager;
            if (key != null) {
                filenet.ws.listener.uddi.api_v2.uddi_org.BusinessEntity be;
                BusinessKey[] keys;
                BusinessDetail bd;
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "businessKey = " + key);
                }
                if ((bd = (uddiManager = WSUddiManager.getWSUddiManager(session, baseURL)).getBusinessDetail(keys = new BusinessKey[]{new BusinessKey(key)})) != null && (be = bd.getBusinessEntity(0)) != null) {
                    Document doc = null;
                    try {
                        doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    }
                    catch (Exception ex) {
                        doc = new DocumentImpl();
                    }
                    Element root = doc.createElement("temproot");
                    doc.appendChild(root);
                    be.saveToXML(root);
                    String string = WSTemplateBase.elementToString(doc);
                    return string;
                }
                uddiManager.cleanup();
            }
            uddiManager = null;
            return uddiManager;
        }
        catch (Exception ex) {
            logger.throwing(m_className, m_method, ex);
            throw ex;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initBusinessEntity() throws VWException {
        String m_method = "initBusinessEntity";
        try {
            logger.entering(m_className, m_method);
            VWUDDIRegistryList uddiRegistryList = new VWUDDIRegistryList(this.m_vwSession);
            if (uddiRegistryList != null) {
                if (!uddiRegistryList.getEnableRegionBusinessEntity()) {
                    this.m_businessEntity = null;
                } else {
                    BusinessEntity be = uddiRegistryList.getRegionBusinessEntity();
                    this.m_businessEntity = new filenet.ws.listener.uddi.api_v2.uddi_org.BusinessEntity(be);
                    if (be.getDiscoveryURLs() == null) {
                        this.m_businessEntity.setDiscoveryURLWithBaseURL(this.m_baseURL, this.m_cpName);
                    }
                    this.m_workflows = this.getWSWorkflows();
                    if (this.m_workflows != null && this.m_workflows.length > 0) {
                        BusinessKey bk = this.m_businessEntity.getBusinessKey();
                        BusinessService[] services = new BusinessService[this.m_workflows.length];
                        this.m_tModels.clear();
                        this.m_services.clear();
                        Vector<TModel> tm = new Vector<TModel>();
                        Vector<BusinessService> svc = new Vector<BusinessService>();
                        Vector<BindingKey> bt = new Vector<BindingKey>();
                        for (int i = 0; i < this.m_workflows.length; ++i) {
                            WSWorkflowServiceInfo serviceInfo = new WSWorkflowServiceInfo(this.m_workflows[i], this.m_baseURL, this.m_isolatedRegion, this.m_authorizedName, this.m_operator, this.m_cpName);
                            TModel tModel = new TModel(serviceInfo);
                            this.m_tModels.put(tModel.getTModelKey().getValue(), tModel);
                            tm.add(tModel);
                            services[i] = new BusinessService(serviceInfo, tModel, bk);
                            this.m_services.put(services[i].getServiceKey().getValue(), services[i]);
                            svc.add(services[i]);
                            if (services[i] == null || services[i].getBindingTemplates() == null) continue;
                            BindingTemplate[] bts = services[i].getBindingTemplates().getBindingTemplate();
                            for (int j = 0; j > bts.length; ++j) {
                                BindingKey bindingKey;
                                if (bts[i] == null || (bindingKey = bts[i].getBindingKey()) == null || bindingKey.getValue() == null) continue;
                                this.m_bindings.put(bindingKey.getValue(), bts[i]);
                                bt.add(bindingKey);
                            }
                        }
                        if (tm != null && tm.size() > 0) {
                            this.m_tModelArray = new TModel[tm.size()];
                            tm.toArray(this.m_tModelArray);
                        }
                        if (svc != null && svc.size() > 0) {
                            this.m_serviceArray = new BusinessService[svc.size()];
                            svc.toArray(this.m_serviceArray);
                        }
                        if (bt != null && bt.size() > 0) {
                            this.m_bindingArray = new BindingTemplate[bt.size()];
                            bt.toArray(this.m_bindingArray);
                        }
                        BusinessServices bs = new BusinessServices();
                        bs.setBusinessService(services);
                        this.m_businessEntity.setBusinessServices(bs);
                    }
                }
            }
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    private VWWorkflowSignature[] findWorkflowByName(String name, boolean bCaseSensitive, boolean bExactMatch) throws Exception {
        String m_method = "findWorkflowByName";
        logger.entering(m_className, m_method);
        try {
            if (this.m_vwSession == null) {
                VWWorkflowSignature[] vWWorkflowSignatureArray = null;
                return vWWorkflowSignatureArray;
            }
            if ((name = name.trim()) == null || name.length() == 0) {
                VWWorkflowSignature[] vWWorkflowSignatureArray = null;
                return vWWorkflowSignatureArray;
            }
            Vector<String> names = new Vector<String>();
            Hashtable<String, VWWorkflowSignature> hTable = new Hashtable<String, VWWorkflowSignature>();
            if (name != null && this.m_vwSession != null) {
                VWWorkflowSignature[] signatures;
                int queryNameLen = -1;
                if (name != null) {
                    queryNameLen = name.length();
                }
                if ((signatures = this.m_vwSession.fetchMultipleWorkflowSignatures(1)) != null && signatures.length > 0) {
                    for (int i = 0; i < signatures.length; ++i) {
                        String wcName;
                        String[] partnerLinkNames;
                        if (signatures[i] == null || (partnerLinkNames = signatures[i].getPartnerlinkNames()) == null || partnerLinkNames.length <= 0 || !signatures[i].getHasMyPortType() || (wcName = signatures[i].getName()) == null) continue;
                        if (queryNameLen > 0) {
                            if (bExactMatch && wcName.length() != queryNameLen) continue;
                            if (wcName.length() >= queryNameLen) {
                                String s = null;
                                s = wcName.substring(0, queryNameLen);
                                if (bCaseSensitive ? VWStringUtils.compare(s, name) != 0 : VWStringUtils.compareIgnoreCase(s, name) != 0) continue;
                            }
                        }
                        names.add(signatures[i].getName());
                        hTable.put(signatures[i].getName(), signatures[i]);
                    }
                }
            }
            VWWorkflowSignature[] workflows = null;
            if (names != null && names.size() > 0) {
                Object[] nameArray = new String[names.size()];
                names.toArray(nameArray);
                VWQuickSort sort = new VWQuickSort(nameArray, 0);
                sort.sort(0, nameArray.length - 1);
                workflows = new VWWorkflowSignature[names.size()];
                for (int i = 0; i < nameArray.length; ++i) {
                    workflows[i] = (VWWorkflowSignature)hTable.get(nameArray[i]);
                }
            }
            VWWorkflowSignature[] vWWorkflowSignatureArray = workflows;
            return vWWorkflowSignatureArray;
        }
        catch (Exception ex) {
            logger.throwing(m_className, m_method, ex);
            throw ex;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VWWorkflowSignature[] getWSWorkflows() throws VWException {
        String m_method = "getWSWorkflows";
        logger.entering(m_className, m_method);
        try {
            if (this.m_vwSession == null) {
                VWWorkflowSignature[] vWWorkflowSignatureArray = null;
                return vWWorkflowSignatureArray;
            }
            Vector<String> names = new Vector<String>();
            VWWorkflowSignature[] signatures = this.m_vwSession.fetchMultipleWorkflowSignatures(1);
            Hashtable<String, VWWorkflowSignature> hTable = new Hashtable<String, VWWorkflowSignature>();
            if (signatures != null && signatures.length > 0) {
                for (int i = 0; i < signatures.length; ++i) {
                    String[] partnerLinkNames;
                    if (signatures[i] == null || (partnerLinkNames = signatures[i].getPartnerlinkNames()) == null || partnerLinkNames.length <= 0 || !signatures[i].getHasMyPortType()) continue;
                    hTable.put(signatures[i].getName(), signatures[i]);
                    names.add(signatures[i].getName());
                }
            }
            VWWorkflowSignature[] workflows = null;
            Object[] nameArray = null;
            if (names != null && names.size() > 0) {
                nameArray = new String[names.size()];
                names.toArray(nameArray);
                VWQuickSort sort = new VWQuickSort(nameArray, 0);
                sort.sort(0, nameArray.length - 1);
                workflows = new VWWorkflowSignature[names.size()];
                for (int i = 0; i < nameArray.length; ++i) {
                    workflows[i] = (VWWorkflowSignature)hTable.get(nameArray[i]);
                }
                hTable.clear();
            }
            VWWorkflowSignature[] vWWorkflowSignatureArray = workflows;
            return vWWorkflowSignatureArray;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    BusinessList findBusiness(Name[] queryNames, boolean bCaseSensitive, boolean bExactMatch) throws VWException {
        String m_method = "findBusiness";
        try {
            logger.entering(m_className, m_method + " caseSensitive=" + bCaseSensitive + " exactMatch=" + bExactMatch);
            BusinessList bl = new BusinessList();
            VWUDDIRegistryList uddiRegistryList = new VWUDDIRegistryList(this.m_vwSession);
            if (uddiRegistryList != null) {
                bl.setGeneric("v2");
                bl.setOperator(this.m_operator);
                if (!uddiRegistryList.getEnableRegionBusinessEntity()) {
                    this.m_businessEntity = null;
                    BusinessList businessList = bl;
                    return businessList;
                }
                BusinessEntity be = uddiRegistryList.getRegionBusinessEntity();
                this.m_businessEntity = new filenet.ws.listener.uddi.api_v2.uddi_org.BusinessEntity(be);
                this.m_operator = be.getOperator();
                bl.setOperator(this.m_operator);
                if (be.getDiscoveryURLs() == null && this.m_baseURL != null) {
                    this.m_businessEntity.setDiscoveryURLWithBaseURL(this.m_baseURL, this.m_cpName);
                }
            }
            boolean bFound = false;
            Name[] names = this.m_businessEntity.getName();
            for (int i = 0; i < names.length && !bFound; ++i) {
                if (names[i] == null || names[i].getValue() == null) continue;
                String aName = names[i].getValue();
                for (int j = 0; j < queryNames.length && !bFound; ++j) {
                    String aQueryName;
                    if (queryNames[j] == null || queryNames[j].getValue() == null || (aQueryName = queryNames[j].getValue()) == null || aQueryName.length() <= 0) continue;
                    bFound = bExactMatch ? VWStringUtils.compare(aName, aQueryName) == 0 : WSUddiManager.isWildCardMatch(aName, aQueryName, bCaseSensitive);
                }
            }
            if (bFound) {
                this.initBusinessEntity();
                BusinessInfos businessInfos = new BusinessInfos();
                BusinessInfo[] businessInfo = new BusinessInfo[]{new BusinessInfo(this.m_businessEntity)};
                businessInfos.setBusinessInfo(businessInfo);
                bl.setBusinessInfos(businessInfos);
            }
            BusinessList businessList = bl;
            return businessList;
        }
        catch (VWException ex) {
            logger.throwing(m_className, m_method, ex);
            throw ex;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    ServiceList findService(String businessKey, Name[] queryNames, boolean bCaseSensitive, boolean bExactMatch) throws VWException {
        String m_method = "findService";
        try {
            logger.entering(m_className, m_method + " businessKey= " + businessKey + " caseSensitive=" + bCaseSensitive + " exactMatch=" + bExactMatch);
            ServiceList sl = new ServiceList();
            ServiceInfos serviceInfos = new ServiceInfos();
            VWUDDIRegistryList uddiRegistryList = new VWUDDIRegistryList(this.m_vwSession);
            if (uddiRegistryList != null) {
                sl.setGeneric("v2");
                sl.setOperator(this.m_operator);
                sl.setServiceInfos(serviceInfos);
                if (!uddiRegistryList.getEnableRegionBusinessEntity()) {
                    ServiceList serviceList = sl;
                    return serviceList;
                }
                BusinessEntity be = uddiRegistryList.getRegionBusinessEntity();
                this.m_operator = be.getOperator();
                sl.setOperator(this.m_operator);
                if (be.getBusinessKey() == null || businessKey == null || businessKey.compareToIgnoreCase(be.getBusinessKey()) != 0) {
                    ServiceList serviceList = sl;
                    return serviceList;
                }
            }
            Hashtable<String, VWWorkflowSignature> wfs = new Hashtable<String, VWWorkflowSignature>();
            for (int i = 0; i < queryNames.length; ++i) {
                try {
                    if (queryNames[i] == null) continue;
                    VWWorkflowSignature[] workflows = this.findWorkflowByName(queryNames[i].getValue(), bCaseSensitive, bExactMatch);
                    for (int j = 0; j < workflows.length; ++j) {
                        if (wfs.get(workflows[j].getName()) != null) continue;
                        wfs.put(workflows[j].getName(), workflows[j]);
                    }
                    continue;
                }
                catch (Exception ex) {
                    logger.log(Level.FINEST, m_className, m_method, ex.getLocalizedMessage(), ex);
                }
            }
            WSWorkflowServiceInfo info = null;
            Vector<ServiceInfo> v = new Vector<ServiceInfo>();
            if (!wfs.isEmpty()) {
                Object obj = null;
                ServiceInfo serviceInfo = null;
                Enumeration enum1 = wfs.elements();
                if (enum1.hasMoreElements() && (obj = enum1.nextElement()) != null && obj instanceof VWWorkflowSignature) {
                    info = new WSWorkflowServiceInfo(obj, this.m_baseURL, this.m_isolatedRegion, this.m_authorizedName, this.m_operator, this.m_cpName);
                    serviceInfo = new ServiceInfo();
                    serviceInfo.setBusinessKey(new BusinessKey(businessKey));
                    serviceInfo.setServiceKey(new ServiceKey(BusinessService.genServiceKeyString(info)));
                    v.add(serviceInfo);
                }
            }
            if (v != null && v.size() > 0) {
                ServiceInfo[] serviceInfoArray = new ServiceInfo[v.size()];
                v.toArray(serviceInfoArray);
                serviceInfos.setServiceInfo(serviceInfoArray);
            }
            ServiceList serviceList = sl;
            return serviceList;
        }
        catch (VWException ex) {
            logger.throwing(m_className, m_method, ex);
            throw ex;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    TModelList findTModel(Name queryName, int maxRows, boolean bCaseSensitive, boolean bExactMatch) throws DispositionReport {
        String m_method = "findTModel";
        try {
            logger.entering(m_className, m_method + " caseSensitive=" + bCaseSensitive + " exactMatch=" + bExactMatch);
            this.initBusinessEntity();
            boolean bFound = false;
            Vector<TModel> tModels = new Vector<TModel>();
            boolean bTruncated = false;
            Collection allTModels = this.m_tModels.values();
            String qName = null;
            if (queryName != null && queryName.getValue() != null) {
                qName = queryName.getValue();
                qName.trim();
                if (qName.length() == 0) {
                    qName = null;
                }
            }
            if (this.m_tModelArray != null && this.m_tModelArray.length > 0) {
                TModel tModel = null;
                String name = null;
                int count = 0;
                boolean bMatch = false;
                for (int i = 0; i < this.m_tModelArray.length; ++i) {
                    tModel = this.m_tModelArray[i];
                    bMatch = false;
                    if (qName == null) {
                        bMatch = true;
                    } else {
                        name = null;
                        if (this.m_tModelArray[i] != null && this.m_tModelArray[i].getName() != null) {
                            name = this.m_tModelArray[i].getName().getValue().trim();
                        }
                        if (name != null) {
                            bMatch = WSUddiManager.isWildCardMatch(name, qName, bCaseSensitive);
                        }
                    }
                    if (!bMatch) continue;
                    if (maxRows == -1 || count < maxRows) {
                        tModels.add(tModel);
                        ++count;
                        continue;
                    }
                    bTruncated = true;
                    break;
                }
            }
            TModelList tl = new TModelList();
            tl.setGeneric("v2");
            tl.setOperator(this.m_operator);
            if (bTruncated) {
                tl.setTruncated(Truncated.value1);
            }
            if (tModels != null && tModels.size() > 0) {
                TModelInfos tModelInfos = new TModelInfos();
                TModelInfo[] tModelInfo = new TModelInfo[tModels.size()];
                for (int i = 0; i < tModels.size(); ++i) {
                    tModelInfo[i] = new TModelInfo((TModel)tModels.get(i));
                }
                tModelInfos.setTModelInfo(tModelInfo);
                tl.setTModelInfos(tModelInfos);
            }
            TModelList tModelList = tl;
            return tModelList;
        }
        catch (VWException ex) {
            logger.throwing(m_className, m_method, ex);
            DispositionReport dr = new DispositionReport(ex.getLocalizedMessage());
            throw dr;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BindingDetail getBindingDetail(BindingKey[] keys) throws DispositionReport {
        String m_method = "getBindingDetail";
        DispositionReport dr = null;
        try {
            logger.entering(m_className, m_method);
            BindingDetail bd = new BindingDetail();
            bd.setGeneric("v2");
            bd.setOperator(this.m_operator);
            if (keys != null && keys.length > 0 && this.m_tModels != null) {
                Object obj = null;
                Vector v = new Vector();
                boolean bInvalidKey = false;
                BindingKey invalidKey = null;
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i] != null && keys[i].getValue() != null) {
                        obj = this.m_bindings.get(keys[i].getValue());
                        if (obj != null && obj instanceof BindingTemplate) {
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, "Found a binding template");
                            }
                            v.add(obj);
                            continue;
                        }
                        invalidKey = keys[i];
                        bInvalidKey = true;
                        break;
                    }
                    bInvalidKey = true;
                    break;
                }
                if (bInvalidKey) {
                    String keyValue = null;
                    if (invalidKey != null && invalidKey.getValue() != null) {
                        keyValue = invalidKey.getValue();
                    }
                    VWException ex = new VWException("filenet.ws.listener.uddi.inquiry_v2.uddi_org.WSUddimanager.invalidBindingKey", "Invalid Binding key - {0}", keyValue);
                    dr = new DispositionReport("E_invalidKeyPassed", 10210, ex.getLocalizedMessage());
                    throw ex;
                }
                if (v.size() > 0) {
                    BindingTemplate[] bt = new BindingTemplate[v.size()];
                    v.toArray(bt);
                    bd.setBindingTemplate(bt);
                }
            }
            BindingDetail bindingDetail = bd;
            return bindingDetail;
        }
        catch (VWException ex) {
            logger.throwing(m_className, m_method, ex);
            if (dr == null) throw dr;
            dr = new DispositionReport(ex.getLocalizedMessage());
            throw dr;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    BusinessDetail getBusinessDetail(BusinessKey[] keys) throws DispositionReport {
        String m_method = "getBusinessDetail";
        BusinessDetail bd = new BusinessDetail();
        DispositionReport dr = null;
        try {
            Serializable bk;
            logger.entering(m_className, m_method);
            if (this.m_businessEntity == null) {
                this.initBusinessEntity();
            }
            if (this.m_businessEntity != null && keys != null && keys.length > 0) {
                bk = this.m_businessEntity.getBusinessKey();
                String bkString = ((BusinessKey)bk).getValue();
                if (keys != null && keys.length > 0) {
                    for (int i = 0; i < keys.length; ++i) {
                        if (keys[i] != null && ((BusinessKey)bk).equals(keys[i])) {
                            BusinessService[] services;
                            filenet.ws.listener.uddi.api_v2.uddi_org.BusinessEntity[] be = new filenet.ws.listener.uddi.api_v2.uddi_org.BusinessEntity[]{this.m_businessEntity};
                            bd.setGeneric("v2");
                            bd.setOperator(this.m_operator);
                            bd.setBusinessEntity(be);
                            BusinessServices bs = be[0].getBusinessServices();
                            if (bs == null || (services = bs.getBusinessService()) == null && services.length <= 0) continue;
                            for (int j = 0; j < services.length; ++j) {
                                if (services[j] == null) continue;
                                Name name = services[j].getName(0);
                                Description d = services[j].getDescription(0);
                                if (name != null && logger.isFinest()) {
                                    logger.finest(m_className, m_method, "service name - " + name.getValue());
                                }
                                if (d == null || !logger.isFinest()) continue;
                                logger.finest(m_className, m_method, "service description - " + d.getValue());
                            }
                            continue;
                        }
                        VWException ex = null;
                        if (keys[i] != null && keys[i].getValue() != null) {
                            ex = new VWException("filenet.ws.listener.uddi.inquiry_v2.uddi_org.WSUddimanager.invalidBusienssKey", "Invalid business key - {0}", keys[i].getValue());
                        }
                        dr = new DispositionReport("E_invalidKeyPassed", 10210, ex.getLocalizedMessage());
                        throw ex;
                    }
                }
            }
            bk = bd;
            return bk;
        }
        catch (VWException ex) {
            logger.throwing(m_className, m_method, ex);
            if (dr == null) {
                dr = new DispositionReport(ex.getLocalizedMessage());
            }
            throw dr;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TModelDetail getTModelDetail(TModelKey[] keys) throws DispositionReport {
        String m_method = "getTModelDetail";
        DispositionReport dr = null;
        try {
            logger.entering(m_className, m_method);
            TModelDetail td = new TModelDetail();
            td.setGeneric("v2");
            td.setOperator(this.m_operator);
            if (keys != null && keys.length > 0 && this.m_tModels != null) {
                Object obj = null;
                Vector v = new Vector();
                boolean bInvalidKey = false;
                TModelKey invalidKey = null;
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i] != null && keys[i].getValue() != null) {
                        obj = this.m_tModels.get(keys[i].getValue());
                        if (obj != null && obj instanceof TModel) {
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, "Found a TModel");
                            }
                            v.add(obj);
                            continue;
                        }
                        invalidKey = keys[i];
                        bInvalidKey = true;
                        break;
                    }
                    bInvalidKey = true;
                    break;
                }
                if (bInvalidKey) {
                    String keyValue = null;
                    if (invalidKey != null && invalidKey.getValue() != null) {
                        keyValue = invalidKey.getValue();
                    }
                    VWException ex = new VWException("filenet.ws.listener.uddi.inquiry_v2.uddi_org.WSUddimanager.invalidTModelKey", "Invalid TModel key - {0}", keyValue);
                    dr = new DispositionReport("E_invalidKeyPassed", 10210, ex.getLocalizedMessage());
                    throw ex;
                }
                if (v.size() > 0) {
                    TModel[] tm = new TModel[v.size()];
                    v.toArray(tm);
                    td.setTModel(tm);
                }
            }
            TModelDetail tModelDetail = td;
            return tModelDetail;
        }
        catch (VWException ex) {
            logger.throwing(m_className, m_method, ex);
            if (dr == null) throw dr;
            dr = new DispositionReport(ex.getLocalizedMessage());
            throw dr;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ServiceDetail getServiceDetail(ServiceKey[] keys) throws DispositionReport {
        String m_method = "getServiceDetail";
        DispositionReport dr = null;
        try {
            logger.entering(m_className, m_method);
            ServiceDetail sd = new ServiceDetail();
            sd.setGeneric("v2");
            sd.setOperator(this.m_operator);
            if (keys != null && keys.length > 0 && this.m_tModels != null) {
                Object obj = null;
                Vector v = new Vector();
                boolean bInvalidKey = false;
                ServiceKey invalidKey = null;
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i] != null && keys[i].getValue() != null) {
                        obj = this.m_services.get(keys[i].getValue());
                        if (obj != null && obj instanceof BusinessService) {
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, "Found a Service");
                            }
                            v.add(obj);
                            continue;
                        }
                        invalidKey = keys[i];
                        bInvalidKey = true;
                        break;
                    }
                    bInvalidKey = true;
                    break;
                }
                if (bInvalidKey) {
                    String keyValue = null;
                    if (invalidKey != null && invalidKey.getValue() != null) {
                        keyValue = invalidKey.getValue();
                    }
                    VWException ex = new VWException("filenet.ws.listener.uddi.inquiry_v2.uddi_org.WSUddimanager.invalidServiceKey", "Invalid Service key - {0}", keyValue);
                    dr = new DispositionReport("E_invalidKeyPassed", 10210, ex.getLocalizedMessage());
                    throw ex;
                }
                if (v.size() > 0) {
                    BusinessService[] bs = new BusinessService[v.size()];
                    v.toArray(bs);
                    sd.setBusinessService(bs);
                }
            }
            ServiceDetail serviceDetail = sd;
            return serviceDetail;
        }
        catch (VWException ex) {
            logger.throwing(m_className, m_method, ex);
            if (dr == null) throw dr;
            dr = new DispositionReport(ex.getLocalizedMessage());
            throw dr;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    private static boolean isWildCardMatch(String name, String queryName, boolean bCaseSensitive) {
        boolean bMatch = false;
        if (name != null && queryName != null && name.length() != 0 && queryName.length() != 0) {
            StringTokenizer st;
            int count;
            if (!bCaseSensitive) {
                name = name.toLowerCase();
                queryName = queryName.toLowerCase();
            }
            if (queryName.indexOf("%") == -1) {
                queryName = queryName + "%";
            }
            if ((count = (st = new StringTokenizer(queryName, "%")).countTokens()) == 0) {
                bMatch = true;
            } else {
                Vector<Object> v = new Vector<Object>();
                for (int i = 0; i < count; ++i) {
                    v.add(st.nextElement());
                }
                String token = null;
                Object s = null;
                int index = 0;
                bMatch = true;
                if (!queryName.startsWith("%")) {
                    if (name.startsWith(token = (String)v.get(index++))) {
                        name = name.substring(token.length(), name.length());
                    } else {
                        bMatch = false;
                    }
                }
                if (bMatch && !queryName.endsWith("%")) {
                    token = (String)v.get(count - 1);
                    if (name.endsWith(token)) {
                        name = name.substring(0, name.length() - token.length());
                        --count;
                    } else {
                        bMatch = false;
                    }
                }
                while (index < count && bMatch) {
                    token = (String)v.get(index);
                    if (name.length() > 0) {
                        int loc = name.indexOf(token);
                        if (loc != -1) {
                            name = name.substring(loc + token.length(), name.length());
                        } else {
                            bMatch = false;
                        }
                    }
                    ++index;
                }
            }
        }
        return bMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        VWCommandLineArgs args = new VWCommandLineArgs(argv);
        try {
            String userName = args.getParameter("name");
            String password = args.getParameter("password");
            StringBuffer buf = new StringBuffer();
            buf.append("rmi://").append(args.getParameter("hostName")).append(":").append(args.getParameter("idmPort")).append("/").append(args.getParameter("router"));
            VWSession session = new VWSession(userName, password, buf.toString());
            WSUddiManager uddiManager = new WSUddiManager(session, args.getParameter("baseURL"));
            Name[] name = new Name[]{new Name("%")};
            BusinessList bl = uddiManager.findBusiness(name, true, false);
            BusinessKey[] bk = new BusinessKey[]{uddiManager.m_businessEntity.getBusinessKey()};
            BusinessDetail bd = uddiManager.getBusinessDetail(bk);
            Document doc = null;
            try {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (Exception ex) {
                doc = new DocumentImpl();
            }
            Element root = doc.createElement("temproot");
            doc.appendChild(root);
            uddiManager.m_businessEntity.saveToXML(root);
            try {
                System.out.println(WSTemplateBase.elementToString(doc));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            System.out.println("Done");
        }
        catch (DispositionReport ex) {
            ex.printStackTrace();
        }
        catch (VWException ex) {
            ex.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }
}

